﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.IO;
using System.Windows.Forms;

namespace SNES_Launcher
{
    public partial class Form_Console : Form
    {
        string Emulator;
        string ROMDir;
        string ROM;
        string Options;
        string OptionsFullScreen;
        string OptionsOther;

        private List<Button> buttonGames = new List<Button>();
        private List<FlowLayoutPanel> panelGames = new List<FlowLayoutPanel>();
        string BoxArtDir = "Box Art\\";

        string GameFileLine;

        private List<ToolTip> toolTipGames = new List<ToolTip>();

        public Form_Console()
        {
            InitializeComponent();

            if (File.Exists("Images\\Branding - Major.png"))
            {
                pictureBox_Branding_Major.BackgroundImage = Image.FromFile("Images\\Branding - Major.png");
            }

            if (File.Exists("Images\\Branding - Minor.png"))
            {
                pictureBox_Branding_Minor.BackgroundImage = Image.FromFile("Images\\Branding - Minor.png");
            }

            if (File.Exists("Files\\Emulators.txt"))
            {
                comboBox_Emulators.DataSource = File.ReadAllLines("Files\\Emulators.txt");
            }

            if (File.Exists("Files\\ROMs Directory.txt"))
            {
                comboBox_ROMs_Directory.DataSource = File.ReadAllLines("Files\\ROMs Directory.txt");
            }

            if (File.Exists("Files\\Games_Inactive.txt"))
            {
                using (StreamReader r = new StreamReader("Files\\Games_Inactive.txt"))
                {

                    while ((GameFileLine = r.ReadLine()) != null)
                    {
                        listBox_Games_Inactive.Items.Add(GameFileLine);
                    }
                }
            }

            if (File.Exists("Files\\Games_Active.txt"))
            {
                using (StreamReader r = new StreamReader("Files\\Games_Active.txt"))
                {
                    while ((GameFileLine = r.ReadLine()) != null)
                    {
                        listBox_Games_Active.Items.Add(GameFileLine);
                        AddGame(GameFileLine);
                    }
                }
            }
        }

        private void buttonGames_Click(object sender, EventArgs e)
        {
            Emulator = comboBox_Emulators.SelectedItem.ToString();
            ROMDir = comboBox_ROMs_Directory.SelectedItem.ToString();
            ROM = "\"" + ROMDir + (sender as Button).Tag.ToString() + ".sfc\"";
            if (checkBox_FullScreen.Checked)
            {
                OptionsFullScreen = " --fullscreen";
            }
            else
            {
                OptionsFullScreen = "";
            }

            OptionsOther = " " + textBox_CommandLineOptions.Text;

            Options = ROM + OptionsFullScreen + OptionsOther;
            
            System.Diagnostics.Process.Start(Emulator, Options);
        }


        private void TransferGames(ListBox source, ListBox destination)
        {
            ListBox.SelectedObjectCollection sourceItems = source.SelectedItems;

            foreach (var item in sourceItems)
            {
                destination.Items.Add(item);
            }
            while (source.SelectedItems.Count > 0)
            {
                source.Items.Remove(source.SelectedItems[0]);
            }
            source.Sorted = true;
            destination.Sorted = true;
        }

        private void button_Games_ToActive_Click(object sender, EventArgs e)
        {
            ListBox.SelectedObjectCollection sourceItems = listBox_Games_Inactive.SelectedItems;
            foreach (var item in sourceItems)
            {
                AddGame(item.ToString());
            }
            TransferGames(listBox_Games_Inactive, listBox_Games_Active);
            SaveGameLists();
        }

        private void button_Games_ToInactive_Click(object sender, EventArgs e)
        {
            ListBox.SelectedObjectCollection sourceItems = listBox_Games_Active.SelectedItems;
            foreach (var item in sourceItems)
            {
                RemoveGame(item.ToString());
            }
            TransferGames(listBox_Games_Active, listBox_Games_Inactive);
            SaveGameLists();
        }

        private void AddGame(string Game)
        {
            buttonGames.Add(new Button());
            buttonGames[buttonGames.Count - 1].Text = "";

            // Check for box art. If not found, then just print the title.
            try
            {
                buttonGames[buttonGames.Count - 1].BackgroundImage = new Bitmap(BoxArtDir + Game + ".jpg");
            }
            catch (Exception e)
            {
                buttonGames[buttonGames.Count - 1].Text = Game;
            }

            buttonGames[buttonGames.Count - 1].BackgroundImageLayout = ImageLayout.Stretch;
            buttonGames[buttonGames.Count - 1].FlatAppearance.BorderSize = 0;
            buttonGames[buttonGames.Count - 1].FlatStyle = FlatStyle.Flat;
            buttonGames[buttonGames.Count - 1].Location = new Point(3, 3);
            buttonGames[buttonGames.Count - 1].Name = "buttonGames_" + Game;
            buttonGames[buttonGames.Count - 1].Size = new Size(118, 86);
            buttonGames[buttonGames.Count - 1].TabIndex = 0;
            buttonGames[buttonGames.Count - 1].UseVisualStyleBackColor = true;
            buttonGames[buttonGames.Count - 1].Tag = Game;
            flowLayoutPanel_Cartridges.Controls.Add(buttonGames[buttonGames.Count - 1]);

            buttonGames[buttonGames.Count - 1].Click += new EventHandler(buttonGames_Click);

            toolTipGames.Add(new ToolTip());
            toolTipGames[toolTipGames.Count - 1].AutoPopDelay = 3000;
            toolTipGames[toolTipGames.Count - 1].InitialDelay = 1000;
            toolTipGames[toolTipGames.Count - 1].ReshowDelay = 500;
            toolTipGames[toolTipGames.Count - 1].ShowAlways = true;
            toolTipGames[toolTipGames.Count - 1].SetToolTip(buttonGames[buttonGames.Count - 1], buttonGames[buttonGames.Count - 1].Tag.ToString());
        }

        private void RemoveGame(string Game)
        {
            for (int i = 0; i < buttonGames.Count; i++)
            {
                if (toolTipGames[i].GetToolTip(buttonGames[i]).CompareTo(Game) == 0)
                {
                    toolTipGames.RemoveAt(i);
                    break;
                }
            }

            foreach (Control c in flowLayoutPanel_Cartridges.Controls)
            {
                if (c is Button)
                {
                    if (c.Tag.ToString().CompareTo(Game) == 0)
                    {
                        c.Click -= new EventHandler(buttonGames_Click);
                        flowLayoutPanel_Cartridges.Controls.Remove(c);
                        c.Dispose();
                    }
                }
            }

            for (int i = 0; i < buttonGames.Count; i++)
            {
                if (buttonGames[i].Tag.ToString().CompareTo(Game) == 0)
                {
                    buttonGames.RemoveAt(i);
                    break;
                }
            }
        }

        private void SaveGameLists()
        {
            StreamWriter SaveFile_Games_Inactive = new StreamWriter("Files\\Games_Inactive.txt");
            foreach (var item in listBox_Games_Inactive.Items)
            {
                SaveFile_Games_Inactive.WriteLine(item.ToString());
            }
            SaveFile_Games_Inactive.Close();
            SaveFile_Games_Inactive.Dispose();

            StreamWriter SaveFile_Games_Active = new StreamWriter("Files\\Games_Active.txt");
            foreach (var item in listBox_Games_Active.Items)
            {
                SaveFile_Games_Active.WriteLine(item.ToString());
            }
            SaveFile_Games_Active.Close();
            SaveFile_Games_Active.Dispose();
        }
    }
}
